/**********************************************************************
 *名称：            AmebaYoutubeListプラグイン
 *要件：            アメバの編集ページで、youtubeサーチしたリストを保存します。   
 *スクリプトファイル　ameba_youtube_list_content.js
 *機能              アメバで、youtube検索をした検索結果を自動でDB保存します。保存後にメッセージを表示
 *50件　ameba_youtube_listテーブルへ
 *リストキーと本体データ(サムネイルとタイトルの配列)
 *
 *extensionIdを格納 
 *これが動作するのは、https://blog.ameba.jp/ucs/entry/srventryinsertinput.do
 *または、https://blog.ameba.jp/ucs/entry/srventryupdateinput.do?...に限定
 ***************************************************************************/
'use strict';
let resp;
let data;
let query_key;
let mark_vid = [];
let vid;
let rs;
let mark;
let param;

/*
*このファイルは、タブをリロードすると実行します。 
*タブ毎に処理が異なるため、先にlocation.hrefで、タブをチェックします。
*・https://autoplay.tecoyan.net
*・https://simplest.tecoyan.net
*・https://blog.ameba.jp/ucs/entry/srventryinsertinput.do
*/
let sw;
if(location.href.indexOf("https://autoplay.tecoyan.net")!==-1||location.href.indexOf("https://simplest.tecoyan.net")!==-1||location.href.indexOf("https://favorite.tecoyan.net")!==-1){
    sw = "remote";
}else if(location.href.indexOf("tecoyan.net")!==-1){
    sw ="tecoyan";
}else if(location.href.indexOf("https://blog.ameba.jp/ucs/entry/srventryinsertinput.do")!==-1||location.href.indexOf("https://blog.ameba.jp/ucs/entry/srventryupdateinput.do")!==-1){
    sw = "ameba";
}
//タブのページ判別
switch(sw){
    //autoplayページ
    case "remote":
    case "tecoyan":
         $("#ext_id")[0].innerText = chrome.runtime.id;
         //
         chrome.runtime.onMessage.addListener(function (msg, sender, sendResponse) {
                //autoplayページに対して、background.jsから、ameba_listメッセージを受信する
                //ここで、リストを生成して、表示している。
                //index.jsの監視が起動する。
                switch (msg.type) {
                    case "ameba_list":
                       if(location.href.indexOf("https://autoplay.tecoyan.net")!==-1||location.href.indexOf("https://simplest.tecoyan.net")!==-1||location.href.indexOf("https://favorite.tecoyan.net")!==-1||location.href.indexOf("http://localhost/autoplay.tecoyan.net")!==-1||location.href.indexOf("http://localhost/simplest.tecoyan.net")!==-1){
                            //ここで、mark vidデータを取得
                            mark_vid = $.ajax({
                                url: 'https://favorite.tecoyan.net/tiny/get_mark_vid.php',
                                type: 'GET',
                                dataType: 'json',
                                //data: param,
                                cache: true,
                                async: false
                            }).responseText;
                            //mark_vid[] markのvid配列データ
                           
                            //リストデータを"#ameba_list"セレクターへ表示する。
                            let html="<ul>";
                            /*
                            *ここで、msg.dataがないケースがあるのは?? 
                            */
                            let aa = Object.values(msg.data);   //ここには、リストの50件の配列データ
                            let ii =0;
                            /***************************************************
                            *リストデータを生成 html
                            *ここで、マークデータを追加できれば、いいが、....
                            *vidをチェックして、あれば、追加できるが、  
                            ****************************************************/
                 
                            for(let dd of aa){
                                //先にmarkデータをチェック
                                //dd.サムネイル(https:\/\/i.ytimg.com/vi/SlIZ1TAlxaA/default.jpg形式)から、vidを取得して、rs = check_vid(vid);をコール
                                //rsに結果(yes/no)が入る
                                console.log("ii "+ii);
                                try{
                                    vid = dd.サムネイル.split("vi/")[1].split("/")[0];
                                    rs = check_vid(vid);
                                    if(rs==="yes"){
                                        mark ="😊" ;

                                    }else{
                                        mark = "";
                                    }
                                }catch(e){
                                    mark = "";
                                }
                     
                                /*********************************************************************
                                *ここで、シングルクォテーションがエスケープされているので、でコードする。
                                *&#39; 
                                **********************************************************************/
                                dd.タイトル = dd.タイトル.replace(/&amp;#39;/g,"'");
                                ii++;
                                //dd = {"サムネイル": thumb, "タイトル": title}
                                //問題なければ、ここで、ameba_list_markテーブルから照合して、マークの追加も可能だが、
                                //処理速度の低下が???　一件毎に実行すると遅くなる。
                                html += "<li name='"+ii+"'>"+ii+".<a class='thumb' href='#'>"+dd.サムネイル+"</a><span class='plist_title' style='font-weight:bold;zoom:1.5;'>  "+dd.タイトル+"</span><span style='zoom:2;' class='mark'>"+mark+"</span></li>"; 

                            }
                            html += "</ul>";
                            //alert("ここで、ameba_listリストを更新します。");
                            //親ページのアメバリストへ表示
                            $("#ameba_list").html(html);
                            alertX("リストを更新しました。新しいリストでお楽しみください。今、表示されているリストが最新になります。😊😊😊",10000);
                            /****************************************************
                            *ここで、リストをDB更新する。
                            * 
                            ****************************************************/
                            update_mark_list();
                            //alert("keyup_listener");
                            keyup_listener();
                            //alert("リストを更新しました。");
                        }
                   break;
                 }
         });    
        break;
    /****************************************************************************
    *今のページは、アメバ　ブログを書くページ
    *
    *
    ****************************************************************************/    
    case "ameba":
        /*******************************************************************************
        *background.jsからのメッセージを受信
        *background.lsからqueryメッセージを受信して、検索フィールドへセットし、検索ボタンを
        *トリガーする。
        * 
        ********************************************************************************/
       chrome.runtime.onMessage.addListener(function (msg, sender, sendResponse) {
           //応答
           //msg.dataがundefinedの場合は抜ける
           if(msg.data !== undefined){
                       
           switch (msg.type) {
               case "query":
                   console.log("時刻　クェリー受信　");
                   //alert("backからクェリーを受信　"+Date());
                   //js-accessoryTab-button
                   let  ee = jQuery.Event('click');
                   //youtubeボタンで検索pop画面表示
                   $('#sidepanel-accessoryTab-youtube').trigger(ee);
                   //DOMへアクセス　クェリーをセットして、検索ボタンをトリガーする。
                   console.log("クェリーをセットします。");
                   //let qq = encodeURI(msg.data);
                   document.querySelector("#js-searchBox-youtube").value = msg.data;
                   //検索ボタンをclickトリガー　検索開始
                   ee = jQuery.Event('click');
                   //検索ボタン
                   $('.p-video__searchButton').trigger(ee);
                   //アメバ編集画面のサイドバーの検索ボタンをクリック
                   //検索後に、保存するため、リストが表示されてから、保存するため、3秒待つ。
                   setTimeout(() => {
                       //if (confirm("保存しますか?")) {
                           //ここでDBへ保存

                           //alert("bodyでクリックしました。");
                           let aaa = document.getElementsByClassName("js-video-item");
                           if (aaa.length !== 0) {
                               //ここで、リストデータを生成して保存
                               //val.innerHTML　この中の<imgタグのsrcを取得　
                               //val.innereText  タイトル
                               let src;
                               let title;
                               data = [];
                               let aa = {};
                               let thumb;
                               $.each(aaa, (i, val) => {
                                   //<imgタグを抽出
                                   src = val.innerHTML.match(/<img[\s\S].*\/div><div/)[0].replace(/<\/div><div/, "");
                                   title = src.split("alt=")[1].replace(/>/, "");
                                   title = title.replace(/"/g, "");
                                   src= src.replace(/src/,"class='my_list' src");
                                   thumb = src.replace(/alt=.*>/, ">");
                                   //srcからサムネイルとタイトルを分けて
                                   aa = {"サムネイル": thumb, "タイトル": title,"マーク":""};
                                   data.push(aa);

                               });
                               //data(配列データ)を保存します。サーバへ
                               //このリストをサーバーへ保存
                               //<imgタグのhtmlデータ
                               //let tt= data[0].サムネイル.split("src=")[1].split(">")[0];

                               let tt =data[0].サムネイル.split('="')[1].replace(/\" >/,"");
                               query_key = $("#js-searchBox-youtube")[0].value;
                               let date = new Date().toLocaleDateString('sv-SE');
                               param = {
                                   query_key: query_key,
                                   date: date,
                                   thumb:tt,
                                   data: data

                               };
                               
                               //alert("thumbの内容　"+data[0].サムネイル);
                               //ここ一か所で、保存
                               resp = $.ajax({
                                   url: 'https://favorite.tecoyan.net/slim/save_ameba_youtube_list.php',
                                   type: 'POST',
                                   dataType: 'html',
                                   data: param,
                                   cache: true,
                                   async: false
                               }).responseText;
                               //このメッセージを親ページで表示
                               console.log(resp);
                               /*******************************************************************
                               *ここでなく、
                               *マーク登録時に行う。
                               * 
                               ********************************************************************/
//                               param = {
//                                   vid: vid
//                               };
//                               /**********************************************************************
//                               *マークを登録
//                               * 
//                               **************************************************************************/
//                               resp = $.ajax({
//                                   url: 'http://favorite.tecoyan.net/tiny/append_ameba_list_mark.php',
//                                   type: 'POST',
//                                   dataType: 'html',
//                                   data: param,
//                                   cache: true,
//                                   async: false
//                               }).responseText;

                           } else {
                               //レングス0

                           }
                           /************************************************************
                           *ameba_listメッセージをbackground.jsへ送信
                           *リストデータも送る 
                           ************************************************************/
                           let ameba_data = {type:'ameba_list',query:query_key,data:data};
                           chrome.runtime.sendMessage(ameba_data, function (msg) {
                               //応答は? 特になし。     

                           });


                       //} else {
                           //保存しない

                       //}
                   }, 2000);
                   //ここで、早めにautoplayをアクティブにしたら、???
                   //background.jsへ依頼する。
                   chrome.runtime.sendMessage({type:"active"}, function (msg) {
                               //応答は? 特になし。     

                   });
                   
                   
                   break;


           }
          }

        });
        /***********************************************************************
        *続けて、以下のquery受信準備完了メッセージをbackへ送る  
        ***********************************************************************/
        console.log("時刻　クェリー受信準備　");
        /*********************************************************************
        *
        ***********************************************************************/
        //先に、youtubeボタンで、検索pop表示しておく 
        let  ee = jQuery.Event('click');
        $('.js-accessoryTab-button').trigger(ee);
        //query受信準備完了メッセージ
        chrome.runtime.sendMessage({type: 'ready'}, function (msg) {
            //応答は? 特になし。     

        });

        break;
    default:
    
    
        break;

}
//このhtmlを、</a>の前に挿入する
//
//<span class="ogpCard_imageWrap" style="position:relative;width:120px;height:120px;flex-shrink:0"><img alt="" class="ogpCard_image" data-ogp-card-image="" height="120" loading="lazy" src="https://s.yimg.jp/images/top/ogp/fb_y_1500px.png" style="position:absolute;top:50%;left:50%;object-fit:cover;min-height:100%;min-width:100%;transform:translate(-50%,-50%)" width="120"></span>

/*******************************************************************************
*youtubeサーチページで、ctrl+alt+clickすると、再生中の動画をマイリストへ出力する。
*DB出力
* 
*********************************************************************************/
$("body").on('click',(e)=>{
        if(e.ctrlKey===true&&e.altKey===true){

            //youtubeサーチであれば、DB出力
            if(location.href.indexOf("https://www.youtube.com/watch?v=") !==-1){
                    //
                    alert("DB出力します。");
                    //サムネイルとタイトルを取得して、オブジェクトデータを生成
                    //v=より、vidを取得して、thumbnailのsrcを生成
                    //
                    
                    let dd = {サムネイル:"https://i.ytimg.com/vi/pZK0WGfBnto/hqdefault.jpg",タイトル:$("h1.ytd-watch-metadata")[0].innerText};
                    alert(dd.タイトル);
//                    let param = {
//                      list_nm = "mylist",  
//                      data:dd  
//                    };
//                    let resp = $.ajax({
//                        url: 'https://simplest.tecoyan.net/push_mylist_db.php',
//                        type: 'POST',
//                        dataType: 'html',
//                        data: param,
//                        cache: true,
//                        async: false
//                    }).responseText;
//                    alert(resp);

            };
        }
});
//markのvidをチェック
//return rs yes/no
function check_vid(dd){
    //
    resp = $.ajax({
        url: 'https://favorite.tecoyan.net/tiny/get_mark_vid.php',
        type: 'GET',
        dataType: 'json',
        //data: param,
        cache: true,
        async: false
    }).responseText;
    vid = JSON.parse(resp);
    //パラメータのvidがあるかをチェック
    for(let vv of vid){
        if(vv['vid'] === dd){
            rs = "yes";
            break;
        }else{
            rs = "no";
        }
   }
    //
    return rs;

}
/******************************************************************************
*マーク入りhtmlデータをDB更新
*リストについたマークのリストをDBへ更新
*
*  
********************************************************************************/
function update_mark_list(){
    //
    let elem = $("li[name]");
    data = [];let aa = [];let ele; 
    //配列のhtmlデータをdataオブジェクトに変換
    //TypeError: elem is not iterableが出る
    //配列のサイズを-2する
    let elems = Object.values(elem);
    elems = elems.slice(0, elems.length - 2);
    
    for(let li of elems){
        aa = [];        //リセット
        //li  ひとつの、<li>データ
        //ここから、サムネイル、タイトル、マークデータを取得
        ele = li.children;
        console.log("ele[0] "+ele[0].innerHTML);
        //a.thumb span.plist_title span.mark
        //aaオブジェクトを生成して、dataへプッシュ
        //srcからサムネイルとタイトルを分けて
        if (ele === undefined || ele === null || ele.length === 0) { // Check if data is undefined, null, or empty
        console.warn("update_mark_list received invalid or empty data.");
        return; // Exit the function gracefully
    }
    const firstItem = ele[0]; // This line is now safe
    // ... rest of the function

        aa = {"サムネイル": ele[0].innerHTML, "タイトル": ele[1].innerText,"マーク":ele[2].innerText};
        data.push(aa);
    }
    //配列をオブジェクト化
    //let data_obj = Object.fromEntries(data.map((value, index) => [index, value]));
    param = {
        query_key: $("#d_query")[0].value,
        data: data
    };    
    resp = $.ajax({
        url: 'https://favorite.tecoyan.net/slim/save_ameba_youtube_list_mark.php',
        type: 'POST',
        dataType: 'html',
        data: param,
        cache: true,
        async: false
    }).responseText;
    console.log(resp);
    
    
    
}
/*******************************************************************************
*keyupリスナーを関数化
*返却値なし。
*  
********************************************************************************/
function keyup_listener(){
        let elem = $("li");
        for( let bb of elem){
            //$(bb).off('keyup');
            $(bb).on('keyup',(e)=>{
                  console.log("今、全サムネイルで定義しているkeyupイベントが入りました。");  
                  //ここで、コードをチェックして、a or z
                  switch(e.key){
                        case "a":
                            //追加
                            //押し続けていると、連続的にイベントが入るので、
                            //1回のみにするが、???2回以降をキャンセルするには、n回入るので、
                            $(".mark")[Number(e.currentTarget.attributes['name'].value)-1].innerText="😊";
                            console.log("登録😊focusされたname=..  "+(Number(e.currentTarget.attributes['name'].value)-1));
                            //ここで、DB更新する。
                            //今のリストから、dataオブジェクトを生成
                            update_mark_list();
                            //vidを追加　ameba_list_markテーブルへ
                            vid = e.target.innerHTML.split("/vi/")[1].split("/")[0];
                            param = {
                                 vid: vid
                            };
                            resp = $.ajax({
                                 url: '././append_mark_db.php',
                                 type: 'POST',
                                 dataType: 'html',
                                 cache: false,
                                 data: param,
                                 async: false
                            }).responseText;
                            console.log("vidを追加しました。"+resp);
                            console.log("update_ameba_youtube_list.php 更新完了");
                            //ここで、以降のイベントをこの回で終わられるには、
                            break;
                        case "z":
                            //削除
                            //$(".mark")[Number(e.target.name)].innerText="";
                            $(".mark")[Number(e.currentTarget.attributes['name'].value)-1].innerText="";
                            console.log("削除😊focusされたname=..  "+(Number(e.currentTarget.attributes['name'].value)-1));                                                 
                            //ここで、DB更新する
                            //今のリストを更新
                            update_mark_list();
                            //vidを削除　ameba_list_markテーブルへ
                            vid = e.target.innerHTML.split("/vi/")[1].split("/")[0];
                            param = {
                                 vid: vid
                            };
                            resp = $.ajax({
                                 url: '././delete_mark_db.php',
                                 type: 'POST',
                                 dataType: 'html',
                                 cache: false,
                                 data: param,
                                 async: false
                            }).responseText;
                            //console.log("vidを削除しました。"+resp);
                            console.log("update_ameba_youtube_list.php 更新完了");                             
                            break;  
                  }
                         //e.defaultPrevented = true;
                         return false;
            });
        }
    
}
//
window.alertX = async function (msg, n) {
    //すでにあればアペンドしない。
    $("#apop2").remove();
    if ($("#apop2").length === 0) {
        let html = "<div id='apop2' style='font-weight:bold;font-size:1.3em;padding:5px;z-index:999999;width:380px;height:200px;background-color:lightgreen;position:fixed;top:10%;left:70%;'>" + msg + "</div>";
        await $("body").append(html);
    }
    $("#apop2").css("display", "block");
    $("#apop2").draggable();

    setTimeout(() => {
        //nミリ秒後に消去
        $("#apop2").css("display", "none");
    }, n);
};

