/**********************************************************************
 *名称：            function_https.js
 *要件：            アメバの編集ページで、youtubeサーチしたリストを保存します。   
 *スクリプトファイル　Select&Save_content.js
 *機能              アメバで、youtube検索をした検索結果を自動でDB保存します。保存後にメッセージを表示
 *50件　ameba_youtube_listテーブルへ
 *リストキーと本体データ(サムネイルとタイトルの配列)
 *
 *extensionIdを格納 
 *これが動作するのは、https://blog.ameba.jp/ucs/entry/srventryinsertinput.do
 *または、https://blog.ameba.jp/ucs/entry/srventryupdateinput.do?...に限定
 ***************************************************************************/
'use strict';
let selectedText;
let ameba_list;
function function_https(){
        //6回コールされているのか。
        console.log("function_https()がコールされています。");
        /***************************************************************************
        * 
        ****************************************************************************/
        //yahooなどのページ 
        sw = "other";
        $("#ext_id").remove();
        $("body").append("<div id='ext_id' style='display:none'></div>");
        //ここで、$("#ext_id")[0].innerText = にセットしておく。
        $("#ext_id")[0].innerText = chrome.runtime.id;
        
        /****************************************************************************
        *documentでテキストを選択してマウスアップすると発火するので、そうではなく、
        *ワンクッションおいてから、発火するように改造
        *ドキュメントで、文字テキストを選択して、マウスアップすると、発火するイベント
        *その時、同時にaltKeyを押しておく 
        ************************************************************************/
        $(document).on('mouseup', function(e){
            //ここでチェックするか
            //これは、大事な処理
            if(e.altKey === false){
                //抜ける
                return;
            }
            /*******************************************************************
            ■*open()する前に、DB検索を先に実行て、リストの有無をチェックする。
            ■*
            ■*******************************************************************/
            //文字テキストを選択
            selectedText = window.getSelection().toString();
            if (selectedText.length > 0) {
                //前後の空白は削除
                selectedText = selectedText.split("\n")[0];
                selectedText = $.trim(selectedText);
                console.log('選択された文字:', selectedText);
                //先にDB検索をしてから、
                let ret = check_db(selectedText);
                if(ret.sts === true){
                    //あれば、DBリストで再生
                    alert("「"+selectedText+"」で、DB検索します。");
                    //ここで、再生する。
                    //youtube_radioと同様に、アベンドする。
                    //リストデータを"#ameba_list"セレクターへ表示する。
                    let html="<button id='setMark' title='ニコニコのトグルスイッチです。' style='zoom:1.5'>😢</button><span id='markStatus'>(ニコニコモード)このボタンは、クリックする毎に、「ニコニコ」と「ソート」が交互に表示されます。</span><ul draggable='true' style='clear:both;'>";
                    /*
                    *ここで、msg.dataがないケースがあるのは?? 
                    */
                    let aa = Object.values(ret.data);   //ここには、リストの50件の配列データ
                    let ii =0;
                    /***************************************************
                    *リストデータを生成 html
                    *ここで、マークデータを追加できれば、いいが、....
                    *vidをチェックして、あれば、追加できるが、  
                    ****************************************************/
                    for(let dd of aa){
                            //先にmarkデータをチェック
                            //dd.サムネイル(https:\/\/i.ytimg.com/vi/SlIZ1TAlxaA/default.jpg形式)から、vidを取得して、rs = check_vid(vid);をコール
                            //rsに結果(yes/no)が入る
                            console.log("ii "+ii);
                            try{
                                vid = dd.サムネイル.split("vi/")[1].split("/")[0];
                                //check_vid()関数呼び出し
                                rs = check_vid(vid);
                                if(rs==="yes"){
                                    mark ="😊" ;

                                }else{
                                    mark = "";
                                }
                            }catch(e){
                                mark = "";
                            }

                            /*********************************************************************
                            *ここで、シングルクォテーションがエスケープされているので、でコードする。
                            *&#39; 
                            **********************************************************************/
                            dd.タイトル = dd.タイトル.replace(/&amp;#39;/g,"'");
                            ii++;
                            //dd = {"サムネイル": thumb, "タイトル": title}
                            //問題なければ、ここで、ameba_list_markテーブルから照合して、マークの追加も可能だが、
                            //処理速度の低下が???　一件毎に実行すると遅くなる。
                            html += "<li class='ameba' name='"+ii+"'>"+ii+".<a class='thumb' href='#'>"+dd.サムネイル+"</a><span class='plist_title' style='font-weight:bold;zoom:1.5;'>  "+dd.タイトル+"</span><span style='zoom:2;' class='mark'>"+mark+"</span></li>"; 

                    }
                    html += "</ul>";
                    //alert("ここで、ameba_listリストを更新します。");
                    //親ページのアメバリストへマーク付きリストを表示
                    //この場合、#ameba_list要素はないケースが多い
                    $("#ameba_list").html(html);
                    alert("検索は、finishしました。　"+location.href);
                    /********************************************************************************
                    *iframeのsrcに指定しているURLのphpファイルでheader("Access-Control-Allow-Origin: *");を
                    *指定しているため、このhtmlページはすべてのサイトで動作可能
                    *ここで、dnm=xxxxをセットする。xxxは、選択した文字テキスト
                    *********************************************************************************/
                    //プレーヤー要素の追加
                    //alert("youtube_radio要素をアペンドします。");
                    html = "<div id='youtube_radio' title='ここでclickするとプラグインの説明を表示します。' style='background-color:lightyellow;z-index:999999;border: 10px solid lawngreen; width: 256px;height: 400px; position: fixed;top:42px;right:0px;'>\n\
            <span  style='position:relative;top:0px;left:0px;font-size:15px;font-weight:bold;'>Tiny♪Player</span>\n\
            <iframe id='iframe_radio' style='position:relative;top:0px;border:solid 2px orange; width:100%;height:95%;' src='https://simplest.tecoyan.net/tiny/index_tiny.php?dnm="+selectedText+"'>\n\
            </iframe>\n\
            </div>";

                    $("#youtube_radio").remove();
                    $("body").append(html);
                    //表示後に、dbから、xxxxのリストを取得して、そのリストを表示する。
                    document.documentElement.webkitRequestFullScreen();
                    $("#youtube_radio").css("display", "block");
                    //extId = chrome.runtime.id;
                    $("#youtube_radio").draggable();                       
                    
                }else{
                    //アメバで検索
                    //文字を確認表示するアラートを表示
                    if (confirm("右矢印の文字列\n\n⇒⇒⇒ 「"+selectedText+"」\n\nでアメバ検索しますか?")){
                        // ここで、選択された文字に対するクリック処理などを検討
                        //アメバ検索ページを開く
                        window.open("https://blog.ameba.jp/ucs/entry/srventryinsertinput.do", "amebatab");
                        //クェリーを渡す(background.js)
                        let qq = selectedText;
                        let data = {'type': 'query', 'query': qq};
                        try {
                            //以下はcontent.jsからbackground.jsへqueryを送信して渡す。
                            chrome.runtime.sendMessage(data, function (msg) {
                                   //応答は? 特になし。     

                            });
                        } catch (e) {
                            //プラグインがインストールされていないケース
                            //ここで、ダウンロードのリンクをつけておく    
                            alertX("<span style='font-weight:bold;color:red;font-size:1.3em;'>お知らせ</span>アメバyoutube検索(GOKボタン)を行うには、先に、連携AmebaYoutubeListプラグインをインストールしてください。<br>　<a href='https://chromewebstore.google.com/detail/%E9%80%A3%E6%90%BAamebayoutubelist%E3%83%97%E3%83%A9%E3%82%B0%E3%82%A4%E3%83%B3/accmjcciplmlohmnpoldpmbpjddmmiag?authuser=0&hl=ja&pli=1'>連携AmebaYoutubeListプラグイン(無料)</a><br>Chromeウェブストアからインストールしてください。<br>(このメッセージは2分後消去されます)", 120000);

                        }; 
                    }else{
                        return false;

                    };                    
                    
                }
                
                
                
            }
        });
        /***************************************************************************
        *background.jsからの'finish'メッセージを待つリスナー関数を登録 
        *
        ***************************************************************************/
        function aaa(msg, sender, sendResponse){
                console.log("'finish'リスナーaaa()が発火しました。　"+sender.origin);
                //background.jsから、finishメッセージを受信する
                switch (msg.type) {
                    case "finish":
                        //ここが6回来るのは????
                        //6回リスナーを登録しているのか。
                        if(location.href.indexOf(msg.url)!==-1){
                                //リストデータを"#ameba_list"セレクターへ表示する。
                                let html="<button id='setMark' title='ニコニコのトグルスイッチです。' style='zoom:1.5'>😢</button><span id='markStatus'>(ニコニコモード)このボタンは、クリックする毎に、「ニコニコ」と「ソート」が交互に表示されます。</span><ul draggable='true' style='clear:both;'>";
                                /*
                                *ここで、msg.dataがないケースがあるのは?? 
                                */
                                let aa = Object.values(msg.data);   //ここには、リストの50件の配列データ
                                let ii =0;
                                /***************************************************
                                *リストデータを生成 html
                                *ここで、マークデータを追加できれば、いいが、....
                                *vidをチェックして、あれば、追加できるが、  
                                ****************************************************/
                                for(let dd of aa){
                                        //先にmarkデータをチェック
                                        //dd.サムネイル(https:\/\/i.ytimg.com/vi/SlIZ1TAlxaA/default.jpg形式)から、vidを取得して、rs = check_vid(vid);をコール
                                        //rsに結果(yes/no)が入る
                                        console.log("ii "+ii);
                                        try{
                                            vid = dd.サムネイル.split("vi/")[1].split("/")[0];
                                            //check_vid()関数呼び出し
                                            rs = check_vid(vid);
                                            if(rs==="yes"){
                                                mark ="😊" ;

                                            }else{
                                                mark = "";
                                            }
                                        }catch(e){
                                            mark = "";
                                        }

                                        /*********************************************************************
                                        *ここで、シングルクォテーションがエスケープされているので、でコードする。
                                        *&#39; 
                                        **********************************************************************/
                                        dd.タイトル = dd.タイトル.replace(/&amp;#39;/g,"'");
                                        ii++;
                                        //dd = {"サムネイル": thumb, "タイトル": title}
                                        //問題なければ、ここで、ameba_list_markテーブルから照合して、マークの追加も可能だが、
                                        //処理速度の低下が???　一件毎に実行すると遅くなる。
                                        html += "<li class='ameba' name='"+ii+"'>"+ii+".<a class='thumb' href='#'>"+dd.サムネイル+"</a><span class='plist_title' style='font-weight:bold;zoom:1.5;'>  "+dd.タイトル+"</span><span style='zoom:2;' class='mark'>"+mark+"</span></li>"; 

                                }
                                html += "</ul>";
                                //alert("ここで、ameba_listリストを更新します。");
                                //親ページのアメバリストへマーク付きリストを表示
                                //この場合、#ameba_list要素はないケースが多い
                                $("#ameba_list").html(html);
                                alert("検索は、finishしました。　"+location.href);
                                /********************************************************************************
                                *iframeのsrcに指定しているURLのphpファイルでheader("Access-Control-Allow-Origin: *");を
                                *指定しているため、このhtmlページはすべてのサイトで動作可能
                                *ここで、dnm=xxxxをセットする。xxxは、選択した文字テキスト
                                *********************************************************************************/
                                //プレーヤー要素の追加
                                //alert("youtube_radio要素をアペンドします。");
                                html = "<div id='youtube_radio' title='ここでclickするとプラグインの説明を表示します。' style='background-color:lightyellow;z-index:999999;border: 10px solid lawngreen; width: 256px;height: 400px; position: fixed;top:42px;right:0px;'>\n\
            <span  style='position:relative;top:0px;left:0px;font-size:15px;font-weight:bold;'>Tiny♪Player</span>\n\
            <iframe id='iframe_radio' style='position:relative;top:0px;border:solid 2px orange; width:100%;height:95%;' src='https://simplest.tecoyan.net/tiny/index_tiny.php?dnm="+selectedText+"'>\n\
            </iframe>\n\
                        </div>";

                                $("#youtube_radio").remove();
                                $("body").append(html);
                                //表示後に、dbから、xxxxのリストを取得して、そのリストを表示する。
                                document.documentElement.webkitRequestFullScreen();
                                $("#youtube_radio").css("display", "block");
                                //extId = chrome.runtime.id;
                                $("#youtube_radio").draggable();                                
                        } 
                        break;
                }
        }
        //
        chrome.runtime.onMessage.removeListener(aaa);
        //background.jsからの'finish'メッセージを待つリスナーを登録        
        chrome.runtime.onMessage.addListener(aaa);
        
                
}
/*******************************************************************************
*check_vid();
*vidを渡し、vidに対応するマークが存在するか否かを返答する。 
**********************************************************************************/
function check_vid(dd){
    //
    resp = $.ajax({
        url: 'https://simplest.tecoyan.net/tiny/get_mark_vid.php',
        type: 'GET',
        dataType: 'json',
        //data: param,
        cache: true,
        async: false
    }).responseText;
    vid = JSON.parse(resp);
    //パラメータのvidがあるかをチェック
    for(let vv of vid){
        if(vv['vid'] === dd){
            rs = "yes";
            break;
        }else{
            rs = "no";
        }
   }
    //
    return rs;

}
//qqでDBチェック
function check_db(qq){
    //
    let param = {
         //■保存データから取得
         query_key: qq
     };
     //■データベースからリストを取得
     var response = $.ajax({
         url: 'https://simplest.tecoyan.net/tiny/get_ameba_youtube_list_html_1.php',
         type: 'POST',
         dataType: 'json',
         cache: false,
         data: param,
         async: false
     }).responseText;
     //■二つの検索結果を取得
     /***********************************************************************
     ■*ここで、&amp;#39;を変換
     ■*ameba_list[0].dd[]
     ■*ameba_list[1].dd[] 不要か? 同じもの
     ■*************************************************************************/
     //■responseにエラーがあると、ここで、続行しない。
     try {
         ameba_list = JSON.parse(response);
         if(ameba_list.length===0){
                //
                alert("リストは存在しません。")
                let dd = {sts:false,data:null};
                return dd;
             
         }else{
                let aa = Object.values(ameba_list);
                //let bb = Object.values(aa[1]);                    

                mk_html(aa[0][1]);
                $("#ameba_list").scrollTop(0);    
                let dd = {sts:true,data:aa[0][1]};
                return dd;
             
         }
     } catch (e) {
         //■エラー
         alertX("urlのクェリーのリストがありません。");
     }


}
/*
* 
*/
function mk_html(data){
        let html = "<button id='setMark' title='ニコニコのトグルスイッチです。' style='zoom:1.5'>😢</button><span id='markStatus'>(ニコニコモード)このボタンは、クリックする毎に、「ニコニコ」と「ソート」が交互に表示されます。</span>";
        let thumb;
        let mark;
        let ii =0;
        html += "<ul draggable='true' style='clear:both;'>";
        //先にDB(ameba_list_markテーブル)より、markデータを配列に読み込んでおく。
        resp = $.ajax({
            url: 'https://simplest.tecoyan.net/tiny/get_mark_vid.php',
            type: 'GET',
            dataType: 'json',
            //data: param,
            cache: false,
            async: false
        }).responseText;
        //mark_array[idx].vidで参照
        let mark_array = JSON.parse(resp);


        let vid;
        $.each(data, (i, val) => {
            //thumb = val['サムネイル'].split("src=")[1].replace(/"/g, '').replace(/ \>/g, '');
            //thumb = thumb.replace(">", "");
            //class='my_list'を追加
            val['サムネイル']= val['サムネイル'].replace(/src/,"class='my_list' src");
            thumb = val['サムネイル'];
            vid = thumb.split("/")[4];
            //ここで、DBテーブルを見て、markをセットするように変更
            if(check_vid(vid)===true){
                //あり
                mark = "😊";
            }else{
                //なし
                mark = "";
            }

            //&#39;->'変換
            val['タイトル'] = val['タイトル'].replace(/&#39;/g,"'"); 
            //if (val['vid'] !== "") {
            //リスト一覧生成
            ii++;
            html += "<li class='ameba' name='"+ii+"'style='padding:1%;clear:both;'>"+ii+".<a class='thumb' href='#'>"+thumb+"</a><span class='plist_title' style='font-weight:bold;font-size:1.3em;'>" + val['タイトル'] + "</span><span style='zoom:2;' class='mark'>"+mark+"</span></li>";
            //}
        });
        html += "</ul>";
        /*ここで、リストを表示 
         *temp_save_tagテーブルのリスト 
         */

        //ここで、リストの更新(入れ替え)をしている。この登録は、ここだけ、
        //これを実行すると、監視が入る。
        $("#ameba_list").html(html);

        //
        function check_vid(vid){
            //
            for(let mm of mark_array){
                if(vid === mm.vid){
                    return true;

                }


            }
            return false;

        }


}     

