/**********************************************************************
*開発:              
*名称：            function_ameba.js
*要件：            アメバの編集ページで、youtubeサーチしたリストを保存します。   
*スクリプトファイル　Select&Save_content.js
*機能              アメバで、youtube検索をした検索結果を自動でDB保存します。保存後にメッセージを表示
*50件　ameba_youtube_listテーブルへ
*リストキーと本体データ(サムネイルとタイトルの配列)
*
*extensionIdを格納 
*これが動作するのは、https://blog.ameba.jp/ucs/entry/srventryinsertinput.do
*または、https://blog.ameba.jp/ucs/entry/srventryupdateinput.do?...に限定
***************************************************************************/
'use strict';
function function_ameba(){
       sw = "ameba";
       /*******************************************************************************
       *これは、background.jsからのメッセージを受信
       *background.lsからqueryメッセージを受信して、検索フィールドへセットし、検索ボタンを
       *トリガーする。
       * 
       ********************************************************************************/
       chrome.runtime.onMessage.addListener(function (msg, sender, sendResponse) {
           //応答
           //msg.dataがundefinedの場合は抜ける
           if(msg.data !== undefined){
                //       
                switch (msg.type) {
                    //
                    case "query":
                        console.log("時刻　クェリー受信　");
                        //alert("backからクェリーを受信　"+Date());
                        //js-accessoryTab-button
                        let  ee = jQuery.Event('click');
                        //youtubeボタンで検索pop画面表示
                        $('#sidepanel-accessoryTab-youtube').trigger(ee);
                        //DOMへアクセス　クェリーをセットして、検索ボタンをトリガーする。
                        console.log("クェリーをセットします。");
                        //let qq = encodeURI(msg.data);
                        document.querySelector("#js-searchBox-youtube").value = msg.data;
                        //検索ボタンをclickトリガー　検索開始
                        ee = jQuery.Event('click');
                        //検索ボタン
                        $('.p-video__searchButton').trigger(ee);
                        //アメバ編集画面のサイドバーの検索ボタンをクリック
                        //検索後に、保存するため、リストが表示されてから、保存するため、3秒待つ。
                        setTimeout(() => {
                            //if (confirm("保存しますか?")) {
                                //ここでDBへ保存

                                //alert("bodyでクリックしました。");
                                let aaa = document.getElementsByClassName("js-video-item");
                                if (aaa.length !== 0) {
                                    //ここで、リストデータを生成して保存
                                    //val.innerHTML　この中の<imgタグのsrcを取得　
                                    //val.innereText  タイトル
                                    let src;
                                    let title;
                                    data = [];
                                    let aa = {};
                                    let thumb;
                                    $.each(aaa, (i, val) => {
                                        //<imgタグを抽出
                                        src = val.innerHTML.match(/<img[\s\S].*\/div><div/)[0].replace(/<\/div><div/, "");
                                        title = src.split("alt=")[1].replace(/>/, "");
                                        title = title.replace(/"/g, "");
                                        src= src.replace(/src/,"class='my_list' src");
                                        thumb = src.replace(/alt=.*>/, ">");
                                        //srcからサムネイルとタイトルを分けて
                                        aa = {"サムネイル": thumb, "タイトル": title,"マーク":""};
                                        data.push(aa);

                                    });
                                    //data(配列データ)を保存します。サーバへ
                                    //このリストをサーバーへ保存
                                    //<imgタグのhtmlデータ
                                    //let tt= data[0].サムネイル.split("src=")[1].split(">")[0];

                                    let tt =data[0].サムネイル.split('="')[1].replace(/\" >/,"");
                                    query_key = $("#js-searchBox-youtube")[0].value;
                                    let date = new Date().toLocaleDateString('sv-SE');
                                    param = {
                                        query_key: query_key,
                                        date: date,
                                        thumb:tt,
                                        data: data

                                    };

                                    //alert("thumbの内容　"+data[0].サムネイル);
                                    //ここ一か所で、保存
                                    resp = $.ajax({
                                        url: 'https://simplest.tecoyan.net/slim/save_ameba_youtube_list.php',
                                        type: 'POST',
                                        dataType: 'html',
                                        data: param,
                                        cache: true,
                                        async: false
                                    }).responseText;
                                    //このメッセージを親ページで表示
                                    console.log(resp);

                                } else {
                                    //レングス0

                                }
                                /************************************************************
                                *ameba_listメッセージをbackground.jsへ送信
                                *リストデータも送る 
                                ************************************************************/
                                let ameba_data = {type:'ameba_list',query:query_key,data:data};
                                chrome.runtime.sendMessage(ameba_data, function (msg) {
                                    //応答は? 特になし。     

                                });


                            //} else {
                                //保存しない

                            //}
                        }, 2000);
                        //ここで、早めにautoplayをアクティブにしたら、???
                        //background.jsへ依頼する。
                        chrome.runtime.sendMessage({type:"active"}, function (msg) {
                                    //alert("親をアクティブにします。");
                                    //応答は? 特になし。     

                        });


                        break;


                }
          }

        });
        /***********************************************************************
        *続けて、以下のquery受信準備完了メッセージをbackへ送る  
        ***********************************************************************/
        console.log("時刻　クェリー受信準備　");
        /*********************************************************************
        *
        ***********************************************************************/
        //先に、youtubeボタンで、検索pop表示しておく 
        let  ee = jQuery.Event('click');
        $('.js-accessoryTab-button').trigger(ee);
        //query受信準備完了メッセージをbackground.jsへ送信
        //
        chrome.runtime.sendMessage({type: 'ready'}, function (msg) {
            //応答は? 特になし。     

        });
        /***********************************************************************
        *check_vid(dd) 
        ************************************************************************/
        function check_vid(dd){
            //
            resp = $.ajax({
                url: 'https://simplest.tecoyan.net/tiny/get_mark_vid.php',
                type: 'GET',
                dataType: 'json',
                //data: param,
                cache: true,
                async: false
            }).responseText;
            vid = JSON.parse(resp);
            //パラメータのvidがあるかをチェック
            for(let vv of vid){
                if(vv['vid'] === dd){
                    rs = "yes";
                    break;
                }else{
                    rs = "no";
                }
           }
            //
            return rs;

        }
        /***********************************************************************
        *マーク入りhtmlデータをDB更新
        *リストについたマークのリストをDBへ更新
        *
        *  
        ************************************************************************/
        function update_mark_list(){
            //
            let elem = $("li.ameba");
            data = [];let aa = [];let ele; 
            //配列のhtmlデータをdataオブジェクトに変換
            //TypeError: elem is not iterableが出る
            //配列のサイズを-2する
            let elems = Object.values(elem);
            elems = elems.slice(0, elems.length - 2);

            for(let li of elems){
                aa = [];        //リセット
                //li  ひとつの、<li>データ
                //ここから、サムネイル、タイトル、マークデータを取得
                ele = li.children;
                console.log("ele[0] "+ele[0].innerHTML);
                //a.thumb span.plist_title span.mark
                //aaオブジェクトを生成して、dataへプッシュ
                //srcからサムネイルとタイトルを分けて
                if (ele === undefined || ele === null || ele.length === 0) { // Check if data is undefined, null, or empty
                console.warn("update_mark_list received invalid or empty data.");
                return; // Exit the function gracefully
            }
            const firstItem = ele[0]; // This line is now safe
            // ... rest of the function

                aa = {"サムネイル": ele[0].innerHTML, "タイトル": ele[1].innerText,"マーク":ele[2].innerText};
                data.push(aa);
            }
            //配列をオブジェクト化
            //let data_obj = Object.fromEntries(data.map((value, index) => [index, value]));
            //dateとthumbを追加

            param = {
                query_key: $("#d_query")[0].value,
                thumb:data[0].サムネイル.split('="')[1].replace(/\" >/,""),
                date: new Date().toLocaleDateString('sv-SE'),
                data: data
            };    
            resp = $.ajax({
                url: 'https://simplest.tecoyan.net/slim/save_ameba_youtube_list_mark.php',
                type: 'POST',
                dataType: 'html',
                data: param,
                cache: true,
                async: false
            }).responseText;
            console.log(resp);



        }
        /*******************************************************************************
        *keyupリスナーを関数化
        *返却値なし。
        *  
        ********************************************************************************/
        function keyup_listener(){
                let elem = $("li");
                for( let bb of elem){
                    //$(bb).off('keyup');
                    $(bb).on('keyup',(e)=>{
                          console.log("今、全サムネイルで定義しているkeyupイベントが入りました。");  
                          //ここで、コードをチェックして、a or z
                          switch(e.key){
                                case "A":
                                case "a":
                                    //追加
                                    //押し続けていると、連続的にイベントが入るので、
                                    //1回のみにするが、???2回以降をキャンセルするには、n回入るので、
                                    $(".mark")[Number(e.currentTarget.attributes['name'].value)-1].innerText="😊";
                                    console.log("登録😊focusされたname=..  "+(Number(e.currentTarget.attributes['name'].value)-1));
                                    //ここで、DB更新する。
                                    //今のリストから、dataオブジェクトを生成
                                    update_mark_list();
                                    //vidを追加　ameba_list_markテーブルへ
                                    vid = e.target.innerHTML.split("/vi/")[1].split("/")[0];
                                    param = {
                                         vid: vid
                                    };
                                    resp = $.ajax({
                                         url: '././append_mark_db.php',
                                         type: 'POST',
                                         dataType: 'html',
                                         cache: false,
                                         data: param,
                                         async: false
                                    }).responseText;
                                    console.log("vidを追加しました。"+resp);
                                    console.log("update_ameba_youtube_list.php 更新完了");
                                    //ここで、以降のイベントをこの回で終わられるには、
                                    break;
                                case "z":
                                    //削除
                                    //$(".mark")[Number(e.target.name)].innerText="";
                                    $(".mark")[Number(e.currentTarget.attributes['name'].value)-1].innerText="";
                                    console.log("削除😊focusされたname=..  "+(Number(e.currentTarget.attributes['name'].value)-1));                                                 
                                    //ここで、DB更新する
                                    //今のリストを更新
                                    update_mark_list();
                                    //vidを削除　ameba_list_markテーブルへ
                                    vid = e.target.innerHTML.split("/vi/")[1].split("/")[0];
                                    param = {
                                         vid: vid
                                    };
                                    resp = $.ajax({
                                         url: '././delete_mark_db.php',
                                         type: 'POST',
                                         dataType: 'html',
                                         cache: false,
                                         data: param,
                                         async: false
                                    }).responseText;
                                    //console.log("vidを削除しました。"+resp);
                                    console.log("update_ameba_youtube_list.php 更新完了");                             
                                    break;  
                          }
                                 //e.defaultPrevented = true;
                                 return false;
                    });
                }

        }
        //
        window.alertX = async function (msg, n) {
            //すでにあればアペンドしない。
            $("#apop2").remove();
            clearTimeout(timeout);
            if ($("#apop2").length === 0) {
                let html = "<div id='apop2' style='border:solid 3px blue;font-weight:bold;font-size:1.3em;padding:5px;z-index:999999;width:600px;height:500px;background-color:lightyellow;position:fixed;top:0%;left:45%;'>" + msg + "</div>";
                await $("body").append(html);
            }
            $("#apop2").css("display", "block");
            $("#apop2").draggable();

            timeout = setTimeout(() => {
                //nミリ秒後に消去
                $("#apop2").css("display", "none");
            }, n);
        };
        function mk_html(data){
                let html = "<button id='setMark' title='ニコニコのトグルスイッチです。' style='zoom:1.5'>😢</button><span id='markStatus'>(ニコニコモード)このボタンは、クリックする毎に、「ニコニコ」と「ソート」が交互に表示されます。</span>";
                let thumb;
                let mark;
                let ii =0;
                html += "<ul draggable='true' style='clear:both;'>";
                //先にDB(ameba_list_markテーブル)より、markデータを配列に読み込んでおく。
                resp = $.ajax({
                    url: 'https://simplest.tecoyan.net/tiny/get_mark_vid.php',
                    type: 'GET',
                    dataType: 'json',
                    //data: param,
                    cache: true,
                    async: false
                }).responseText;
                //mark_array[idx].vidで参照
                let mark_array = JSON.parse(resp);


                let vid;
                $.each(data, (i, val) => {
                    //thumb = val['サムネイル'].split("src=")[1].replace(/"/g, '').replace(/ \>/g, '');
                    //thumb = thumb.replace(">", "");
                    //class='my_list'を追加
                    val['サムネイル']= val['サムネイル'].replace(/src/,"class='my_list' src");
                    thumb = val['サムネイル'];
                    vid = thumb.split("/")[4];
                    //ここで、DBテーブルを見て、markをセットするように変更
                    if(check_vid(vid)===true){
                        //あり
                        mark = "😊";
                    }else{
                        //なし
                        mark = "";
                    }

                    //&#39;->'変換
                    val['タイトル'] = val['タイトル'].replace(/&#39;/g,"'"); 
                    //if (val['vid'] !== "") {
                    //リスト一覧生成
                    ii++;
                    html += "<li class='ameba' name='"+ii+"'style='padding:1%;clear:both;'>"+ii+".<a class='thumb' href='#'>"+thumb+"</a><span class='plist_title' style='font-weight:bold;font-size:1.3em;'>" + val['タイトル'] + "</span><span style='zoom:2;' class='mark'>"+mark+"</span></li>";
                    //}
                });
                html += "</ul>";
                /*ここで、リストを表示 
                 *temp_save_tagテーブルのリスト 
                 */

                //ここで、リストの更新(入れ替え)をしている。この登録は、ここだけ、
                //これを実行すると、監視が入る。
                $("#ameba_list").html(html);

                /***********************************************************************
                *このリストを更新したいが、
                *😊マークを保存したいが、これは、サムネイルとリンクしている。
                *DBのリストデータ(50件の動画情報)　ameba_youtube_listテーブル
                *全てのimg要素にkeyupリスナー定義
                *  
                ************************************************************************/
                setTimeout(()=>{
                         //リストのサムネイルに対してkeyupイベントを登録しているが、
                         //
                         //let elem = document.getElementsByClassName('my_list');
                         keyup_listener();



                 },1000);



                //
                my = $(".my_list");

                for(let mm of my){
                    $(mm).off();
                    $(mm).on({
                        'mouseenter':function (e){
                                    //
                                    if(hoverSwitch==="off"){
                                        return false;
                                    }
                                    $("#manual").css("display","none");
                                                        //コメントはDBから取得
                                    let vid = e.currentTarget.parentElement.querySelectorAll(".my_list")[0].src.split("/vi/")[1].split("/")[0];
                                    let mess = getCommentByVid(vid);
                                    mess = "<div style='background-color:lightyellow'>"+mess+"</div>";
                                    alertX("サムネイル "+e.currentTarget.parentElement.nextSibling.innerText+"<br>●ここをクリックすると、再生します。同時にタイトル色が赤で表示されます。<br><span style='background-color:lightpink;'>以下はコメント欄です。</span><br><button id='comment' style='background-color:lightblue;'>コメント入力</button><div id='com_input' style='display:none;'><textarea id='com_text' style='width;319px;height:79px;'></textarea><br><button id='com_save'>保存</button><button id='com_cancel'>キャンセル</button></div><br>"+mess,10000);
                                    $("#apop").css({"position":"fixed","top":"30%","left":"50%"});


                          }

                    });  
                }
                //
                my = $(".plist_title");
                for(let mm of my){
                    $(mm).off();
                    $(mm).on({
                        'mouseenter':function (e){
                                    if(hoverSwitch==="off"){
                                        return false;
                                    }
                                    $("#manual").css("display","none");
                                    //
                                    alertX("タイトル　"+mm.innerText+"<br>●ここのタイトルをマウスのカーソルで選択してクリックすると、選択した文字列をクェリー入力へ転記します。<br>アメバ検索で、検索するときに便利です。",10000);
                                    $("#apop").css({"position":"fixed","top":"30%","left":"50%"});
                          }

                    });  
                }
                //
                function check_vid(vid){
                    //
                    for(let mm of mark_array){
                        if(vid === mm.vid){
                            return true;

                        }


                    }
                    return false;

                }


        }
/*********************************************************************************
*pasteイベントを拾って、ここで、Tiny♪Playerサイトのカード型リンクを生成
*規格書では、iframeの場合は、postMessageを使うと出ているが、
*プラグインからのDOMアクセス(iframe)は、オリジンが異なるため、CORSエラーになるが、
*********************************************************************************/    
const iframe = $("iframe.cke_wysiwyg_frame.cke_reset");
//これだと、リスナーが効いている。
let bdy = iframe[0].contentDocument.querySelector("body");
//ここで、エラー発生
//pasteされたら、イベントを発火するリスナーを登録   
bdy.addEventListener('paste', (event) => {
  //ここで、1秒待てば、貼り付けは終了しているので、リスナーを登録できる。  
  setTimeout(()=>{  
          // ここにイベント発火後の処理を書きます
          //alert('何か貼り付けられました！');
          // 例：クリップボードのテキストを取得
          const pastedText = event.clipboardData.getData('text');
          console.log('貼り付けた内容:', pastedText);
          let dd = document.querySelectorAll("iframe")[2].contentDocument.querySelectorAll(".ogpCard_root");
          let ww;let href;let qq;
          /***************************************************************
          *dd(オブジェクトデータ)に本文からすべてのogpCard_rootセレクターを取得して、
          *それぞれの要素に対して、さらにogpCard_wrapセレクターを取得して、そのinnerText内に
          *「なつかしの曲」テキストが含まれているかをチェック(これはサイトのリンク)
          *  
          *****************************************************************/
          for(let ss of dd){
                  //ss(calss='ogpCard_root')の中から、".ogpCard_wrap"セレクターをすべて取得します。
                  ww = ss.querySelectorAll(".ogpCard_wrap");
                  if(ww.length===0){
                      continue;
                  }
                  if(ww[0].innerText.indexOf("なつかしの曲") === -1&&ww[0].innerText.indexOf("Tiny♪Player") === -1){
                      continue;
                  }
                  /*********************************************************************
                  *さらにその中から、<articleタグを探し、そこの<aタグの最後に、<imgのサムネイルタグ
                  *を追加します。
                  *テンプレートを挿入してから、srcを更新します。 
                  *<img class="my_list" height="40" loading="eager" name="0" src="https://i.ytimg.com/vi/yAFhH9GpCL0/default.jpg" style="position: relative;top: -116px;left: 80%;width: 150px;left: 75%;" width="120"
                  *<span class="ogpCard_imageWrap" style="position:relative;width:120px;height:120px;flex-shrink:0"><img alt="" class="ogpCard_image" data-ogp-card-image="" height="120" loading="lazy" src="https://i.ytimg.com/vi/T0SlWuQreLo/default.jpg" style="position:absolute;top:50%;left:50%;object-fit:cover;min-height:100%;min-width:100%;transform:translate(-50%,-50%)" width="120"></span>
                  *
                  **********************************************************************/
                  //サムネイルをDBから取得する。
                  //クェリー名をキーにして、ww[0].querySelectorAll("a")[0].hrefで取得して
                  //クェリー名を取得　?dnm=xxxxxxで
                  href = ww[0].querySelectorAll("a")[0].href;
                  qq=decodeURIComponent(href.split("=")[1].split("#")[0]);
                  let params = {
                      query: qq
                  };
                  var resp = $.ajax({
                      url: 'https://simplest.tecoyan.net/slim/get_ameba_youtube_list_thumb_db.php',
                      type: 'POST',
                      dataType: 'html',
                      cache: false,
                      data: params,
                      async: false
                  }).responseText;

                  // 作成した要素を</body>の直前に挿入
                  //document.body.appendChild(parentElement);
                  //すでにある場合はアペンドしない
                  if(ww[0].querySelectorAll(".my_list").length === 0){
                          // 親要素を作成
                          const parentElement = document.createElement('span');

                          // 子要素を作成
                          const childElement1 = document.createElement('img');
                          //class src属性を追加
                          childElement1.className = "my_list";
                          childElement1.src = resp;
                          childElement1.style.cssText = 'position: relative;top: 0px;left: 50%;width: 180px;';
                          // 親要素に子要素を追加
                          parentElement.appendChild(childElement1);    //<img
                          const childElement2 = document.createElement('span');
                          // テキストノードを作成
                          const textNode = document.createTextNode(qq);

                          // 子要素にテキストノードを追加
                          childElement2.appendChild(textNode);
                          parentElement.appendChild(childElement2);    //<span
                          childElement2.style.cssText = 'background-color:rgba(255, 255, 255, 0.2);top:-51px;z-index: 9999;width:300px;position: relative;display: block;left: -150px';
                          ww[0].querySelectorAll("a")[0].appendChild(parentElement);
                          ww[0].querySelectorAll("a")[0].innerText.replace(/&lt;/g,"<").replace(/&gt;/g,">");
                          console.log("テスト");
                  }

          }
          return false;
  },1000);
});        
        
       
}

